
# ------------------ VORBEREITUNG DER DATEN ----------------------------------

#Daten importieren und benennen
setwd("~/PROMOTION/Studiendurchführung/R-Testrechnungen")

# Datensätze einlesen
dat <- read.delim("testreihe.txt")
test <- read.delim("test.txt")
metadaten <- read.delim("metadaten_p.txt")
frakis <- read.delim("frakis.txt")
stimuli_mmp <- read.delim("stimuli_mmp.txt")

# Datensätze miteinander verbinden 
data_0 <- merge(dat, test, by="ID_Test")
data_1 <- merge(data_0, frakis, by= "ID_FRAKIS")
data_2 <- merge(data_1, metadaten, by= "ID_Proband")
data_3 <- merge(data_2, stimuli_mmp, by="ID_Stimulus")

##Vorbereitung der Daten 
library(tidyverse)
# Umbenennung von Einflussvariablen
data_3 <- rename(data_3, Durchgefuehrtes_Experiment = Experiment.y)
data_3 <- rename(data_3, Phonemart = Fruehe_Phoneme)
data_3 <- rename(data_3, Wortschatz_FrakisK = WS_Perzentilspanne_ID)

#Einflussvariable Experiment in Faktorvariable ändern, Label festlegen 
data_3$Durchgefuehrtes_Experiment <- factor(data_3$Durchgefuehrtes_Experiment,levels = c(2,1), 
                              labels = c("Vokalexperiment", "Konsonantenexperiment"))
data_3$Bewertung <- factor(data_3$Bewertung,levels = c(0,1), 
                           labels = c("nicht gemerkt", "gemerkt"))

#Spalte Altersgruppe bzgl. Vokabelspurt hinzufügen
data_3$Altersgruppe_Vokabelspurt <- data_3$ID_Altersgruppe
data_3$Altersgruppe_Vokabelspurt[(data_3$Altersgruppe_Vokabelspurt == 1) | (data_3$Altersgruppe_Vokabelspurt == 2)] <- 5
data_3$Altersgruppe_Vokabelspurt[(data_3$Altersgruppe_Vokabelspurt == 3) | (data_3$Altersgruppe_Vokabelspurt == 4)] <- 6

data_3$Altersgruppe_Vokabelspurt <- factor(data_3$Altersgruppe_Vokabelspurt,
                                           levels = c(5,6), 
                                           labels = c("juenger als 24 Monate", "24 Monate oder aelter"))

data_3$silbenstruktur <- factor(data_3$einsilbig,levels = c(0,1), 
                                           labels = c("mehrsilbig", "einsilbig"))

data_3$KM_Produktionsort <- factor(data_3$KM_Produktionsort,levels = c(0,1), 
                                   labels = c("kein Kontrast im Produktionsort", "Kontrast im Produktionsort"))

data_3$KM_Stimmhaft <- factor(data_3$KM_Stimmhaft,levels = c(0,1), 
                                   labels = c("kein Kontrast Stimmhaftigkeit", "Kontrast Stimmhaftigkeit"))

data_3$KM_Hoehe <- factor(data_3$KM_Hoehe,levels = c(0,1), 
                              labels = c("kein Kontrast in der Vokalhöhe", "Kontrast in der Vokalhöhe"))

data_3$Phonemart <- factor(data_3$Phonemart,levels = c(0,1), 
                          labels = c("kein fruehes Phonem", "fruehes Phonem"))

data_3$Stoerfaktor <- factor(data_3$Stoerfaktor,levels = c(0,1), 
                                labels = c("nein", "ja"))

#Variable Position_Testreihe in Faktorvariable ändern 
data_3$Position_Testreihe <- factor(data_3$Position_Testreihe)

#Variable Alter_Monate in Faktorvariable ändern 
data_3$Alter_Monate <- factor(data_3$Alter_Monate)

#Variable ID_Objektset in Faktorvariable ändern 
data_3$ID_Objektset <- factor(data_3$ID_Objektset)

#Einflussvariable ID_FRAKIS in Faktorvariable ändern 
data_3$ID_FRAKIS <- factor(data_3$ID_FRAKIS)

#Einflussvariable ID_Altersgruppe in Faktorvariable ändern 
data_3$ID_Altersgruppe <- factor(data_3$ID_Altersgruppe)

#Einflussvariable ID_Proband in Faktorvariable ändern 
data_3$ID_Proband <- factor(data_3$ID_Proband)

#Einflussvariable Wortschatz_FrakisK in Faktorvariable ändern 
data_3$Wortschatz_FrakisK <- factor(data_3$Wortschatz_FrakisK)
nrow(data_3)

# Bereinigter Datensatz ohne Mehrsprachige Kinder aber mit Störfaktoren
data_3_1 <- data_3[data_3$D_Einsprachig=="ja", ]
nrow(data_3_1)

# Bereinigter Datensatz ohne Mehrsprachige Kinder und ohne Störfaktoren
data_4 <- data_3[(data_3$Stoerfaktor=="nein") & (data_3$D_Einsprachig=="ja"), ]
nrow(data_4)

# zusätzlich bereinigter Datensatz ohne Tests mit Ws über/unter Normbereich
data_5 <- data_4[data_4$Wortschatz_FrakisK %in% c(2,3,4,5),]
nrow(data_5)

# zusätzliche Einschränkungen des bereinigten Datensatzes nach Experiment 1 & 2
data_4_E1 <- data_4[data_4$Durchgefuehrtes_Experiment == "Konsonantenexperiment",]
  
data_4_E2 <- data_4[data_4$Durchgefuehrtes_Experiment == "Vokalexperiment",]

# zusätzliche Einschränkung des bereinigten Datensatzes data_4 auf gemerkte Tests
data_6 <- data_4[data_4$Bewertung=="gemerkt", ]
nrow(data_6)

# Teilstichprobe mit allen bereinigten Tests der Probanden mit 16 Monaten (Studienreplikation)
data_7 <- data_4[data_4$Alter_Monate==16, ]
nrow(data_7)

data_7_unbereinigt <- data_3[data_3$Alter_Monate==16, ]
nrow(data_7_unbereinigt)

# ------------------ DATENVISUALISIERUNG MIT BAR- & MOSAIKPLOTS ----------------------------------

# benötigte Pakete laden
library(ggplot2)
install.packages("ggmosaic")
library(ggmosaic)

# Theme für alle Plots festlegen
mytheme <- theme(
  plot.title = element_text(face = "bold", size = 12, hjust = 0.5),
  plot.subtitle = element_text(size = 12, hjust = 0.5),
  legend.background = element_rect(fill = "white", size = 4, colour = "white"),
  text=element_text(size=12,  family="serif"),
  axis.ticks = element_line(colour = "grey70", size = 0.2),
  panel.grid.major = element_line(colour = "grey70", size = 0.2),
  panel.grid.minor = element_blank()
)

## ------------------ Verteilung der durchgeführten Testreihen ----------------------------------

# ABBILDUNG 25
# Barplot zur Übersicht über die durchgeführten Einzeltests in Experiment 1 und 2 innerhalb der Testpersonengruppen
ggplot(data=data_4, aes(y= ..count..,
           x=Durchgefuehrtes_Experiment, 
           fill=ID_Altersgruppe,
           label = scales::percent(prop.table(stat(count)))))+
  geom_bar(position="dodge")+
  geom_text(stat = 'count',
            position = position_dodge(.9), 
            vjust = -0.5, 
            size = 3,
            family="serif") + 
  labs(x="Experiment",y="Anzahl der durchgeführten Einzeltests", 
       title = "Durchgeführte Einzeltests nach Altersgruppen") +
  theme_bw()+
  scale_fill_grey(start = .2, end = .8, 
                  name="Altersgruppe",
                  labels = c("1 (16-19 Monate)", "2 (20-23 Monate)", "3 (24-27 Monate)", "4 (28-32 Monate)"))+
  mytheme

# ABBILDUNG 26
# Barplot zur Übersicht über die Verteilung der Wortschatzgröße der Testpersonen zum Zeitpunkt aller durchgeführten Tests
ggplot(data=data_4[data_4$Alter_Monate %in% seq(18, 30),], aes(y= ..count..,#prop.table(stat(count)), 
                        x=ID_Altersgruppe,
                        fill=Wortschatz_FrakisK,
                        label = scales::percent(prop.table(stat(count)))))+
  geom_bar(position="dodge")+
  geom_text(stat = 'count',
            position = position_dodge(.9), 
            vjust = -0.5, 
            size = 3,
            family="serif") + 
  labs(x="Altersgruppe",y="Anzahl der durchgeführten Einzeltests", 
       title = "Wortschatzgröße der Probanden bei allen durchgeführten Einzeltests nach Altersgruppen") +
  theme_bw()+
  scale_fill_grey(start = .01, end = .95,
                  name="Interpretation der Wortschatzgröße nach FKRAKIS-K",
                  labels = c("unterhalb des Normbereichs", "unterer Normbereich", 
                             "(unterer) mittlerer Normbereich", "(oberer) mittlerer Normbereich",
                             "oberer Normbereich", "oberhalb des Normbereichs"),
                  guide = guide_legend(title.position = "top", title.hjust = 0.5))+
  mytheme

## ------------------ Dauerhafter Einflussfaktor WS-Größe ----------------------------------

# ABBILDUNG 27
# Mosaikplot zur Verteilung der Merkbarkeit in Experiment 1 in den Gruppen der interpretierten Wortschatzgrößen gemäß FRAKIS-K
data_mosaik_merkbarkeit_e1 <- data.frame(table(data_4_E1$Wortschatz_FrakisK, data_4_E1$Bewertung))
ggplot(data_mosaik_merkbarkeit_e1)+
  geom_mosaic(aes(
    x=product(Var2,Var1),
    fill=Var2,
    weight=Freq
  ))+
  labs(x="interpretierte Wortschatzgröße nach FRAKIS-K", y="Bewertung der Einzeltests",
       title = "Merkbarkeit in Experiment 1 (Konsonantenexperiment)") +
  theme_bw()+
  scale_fill_grey(start = .2, end = .8,
                  name="Bewertung")+
  mytheme

# ABBILDUNG 28
# Mosaikplot zur Verteilung der Merkbarkeit in Experiment 2 in den Gruppen der interpretierten Wortschatzgrößen gemäß FRAKIS-K
data_mosaik_merkbarkeit_e2 <- data.frame(table(data_4_E2$Wortschatz_FrakisK, data_4_E2$Bewertung))
ggplot(data_mosaik_merkbarkeit_e2)+
  geom_mosaic(aes(
    x=product(Var2,Var1),
    fill=Var2,
    weight=Freq
  ))+
  labs(x="interpretierte Wortschatzgröße nach FRAKIS-K", y="Bewertung der Einzeltests",
       title = "Merkbarkeit in Experiment 2 (Vokalexperiment)") +
  theme_bw()+
  scale_fill_grey(start = .2, end = .8,
                  name="Bewertung")+
  mytheme

## ------------------ Hypothese 1 ----------------------------------

# ABBILDUNG 29
# Mosaikplot zur Verteilung der gemerkten/nicht gemerkten Tests in Experiment 1 und 2
data_mosaik <- data.frame(table(data_4$Durchgefuehrtes_Experiment, data_4$Bewertung))
ggplot(data_mosaik)+
  geom_mosaic(aes(
    x=product(Var2,Var1),
    fill=Var2,
    weight=Freq
  ))+
  labs(x="Experiment", y="Bewertung der Einzeltests",
       title = "Allgemeine Merkbarkeit in Experiment 1 & 2") +
  theme_bw()+
  scale_fill_grey(start = .2, end = .8,
                  name="Bewertung")+
  mytheme
  
# ABBILDUNG 30
# Mosaikplot zur Verteilung der gemerkten/nicht gemerkten Tests in Experiment 1 und 2 in der Teilstichprobe von Tests mit einem nach FRAKIS-K interpretierten Wortschatz im Normbereich
data_mosaik <- data.frame(table(data_5$Durchgefuehrtes_Experiment, data_5$Bewertung))
ggplot(data_mosaik)+
  geom_mosaic(aes(
    x=product(Var2,Var1),
    fill=Var2,
    weight=Freq
  ))+
  labs(x="Experiment", y="Bewertung der Einzeltests",
       title = "Allgemeine Merkbarkeit in Experiment 1 & 2",
       subtitle="Teilstichprobe: Tests mit interpretiertem Wortschatz im Normbereich") +
  theme_bw()+
  scale_fill_grey(start = .2, end = .8,
                  name="Bewertung")+
  mytheme

# ABBILDUNG 31
# Mosaikplot zur Verteilung der gemerkten Einzeltests in Experiment 1 & 2 nach ein- und mehrsilbigen Minimalpaaren
data_mosaik_silbenstruktur <- data.frame(table(data_6$Durchgefuehrtes_Experiment, data_6$silbenstruktur))
ggplot(data_mosaik_silbenstruktur)+
  geom_mosaic(aes(
    x=product(Var2,Var1),
    fill=Var2,
    weight=Freq
  ))+
  labs(x="Experiment", y="Silbenstruktur im Stimulus-Minimalpaar",
       title = "Gemerkte Einzeltests bei ein- und mehrsilbigen Minimalpaaren") +
  theme_bw()+
  scale_fill_grey(start = .2, end = .8,
                  name="Silbenstruktur")+
  mytheme


# ABBILDUNG 32
# Übersicht über die Verteilung der gemerkten/nicht gemerkten Tests in Experiment 1 und 2 bei Testpersonen im Alter von 16 Monaten (Altersgruppe der replizierten Studie) in einer nach Störfaktoren bereinigten Teilstichprobe.
data_mosaik <- data.frame(table(data_7$Durchgefuehrtes_Experiment, data_7$Bewertung))
ggplot(data_mosaik)+
  geom_mosaic(aes(
    x=product(Var2,Var1),
    fill=Var2,
    weight=Freq
  ))+
  labs(x="Experiment", y="Bewertung der Einzeltests",
       title = "Allgemeine Merkbarkeit in Experiment 1 & 2",
       subtitle = "bereinigte Teilstichprobe der Einzeltests mit Probanden im Alter von 16 Monaten") +
  theme_bw()+
  scale_fill_grey(start = .2, end = .8,
                  name="Bewertung")+
  mytheme


## ------------------ Hypothese 2 ----------------------------------

# ABBILDUNG 33
# Mosaikplot zur Verteilung der gemerkten Einzeltests in Experiment 1 & 2 nach Minimalpaaren mit früh und nicht früh erworbenen Phonemen als bedeutungsunterscheidendes Element 
data_mosaik_phonemart <- data.frame(table(data_6$Durchgefuehrtes_Experiment, data_6$Phonemart))
ggplot(data_mosaik_phonemart)+
  geom_mosaic(aes(
    x=product(Var2,Var1),
    fill=Var2,
    weight=Freq
  ))+
  labs(x="Experiment", y="Phonemart im Stimulus-Minimalpaar",
       title = "Gemerkte Einzeltests bei Minimalpaaren mit frühen / nicht frühen Phonemen") +
  theme_bw()+
  scale_fill_grey(start = .2, end = .8,
                  name="Phonemart")+
  mytheme

## ------------------ Hypothese 3 ----------------------------------

# ABBILDUNG 34
# Mosaikplot zur Verteilung der gemerkten Einzeltests in Experiment 1 & 2 nach vier Altersgruppen 
data_mosaik_merkbarkeit_alter <- data.frame(table(data_6$Durchgefuehrtes_Experiment, data_6$ID_Altersgruppe))
ggplot(data_mosaik_merkbarkeit_alter)+
  geom_mosaic(aes(
    x=product(Var2,Var1),
    fill=Var2,
    weight=Freq
  ))+
  labs(x="Experiment", y="Altersgruppe",
       title = "Gemerkte Einzeltests nach Altersgruppen") +
  theme_bw()+
  scale_fill_grey(start = .2, end = .8,
                  name="Altersgruppe",
                  labels = c("1 (16-19 Monate)", "2 (20-23 Monate)", "3 (24-27 Monate)", "4 (28-32 Monate)"))+
  mytheme


# ABBILDUNG 35
# Mosaikplot zur Verteilung der gemerkten Einzeltests in Experiment 1 & 2 nach den zwei zusammengefassten Altersgruppen, die das Alter der Testpersonen vor und nach dem 24. Lebensmonat abbilden.
data_mosaik_merkbarkeit_alter_vs <- data.frame(table(data_6$Durchgefuehrtes_Experiment, data_6$Altersgruppe_Vokabelspurt))
ggplot(data_mosaik_merkbarkeit_alter_vs)+
  geom_mosaic(aes(
    x=product(Var2,Var1),
    fill=Var2,
    weight=Freq
  ))+
  labs(x="Experiment", y="Altersgruppe",
       title = "Gemerkte Einzeltests vor / nach dem 2. Lebensjahr") +
  theme_bw()+
  scale_fill_grey(start = .2, end = .8,
                  name="Altersgruppe")+
  mytheme


# ABBILDUNG 36
# Barplot zur Verteilung der gemerkten Einzeltests in Experiment 1 & 2 nach Alter der Testpersonen in Monaten
ggplot(data=data_6, aes(y= ..count..,
                        x=Durchgefuehrtes_Experiment,
                        fill=Alter_Monate,
                        label = Alter_Monate))+
  geom_bar(position="dodge")+
  labs(x="Experiment", y="Anzahl der gemerkten Einzeltests",
       title = "Gemerkte Einzeltests nach Alter in Monaten",
       label = Alter_Monate) +
  theme_bw()+
  scale_fill_grey(start = .2, end = .8,
                  name="Alter in Monaten")+
                  
  mytheme


# ------------------ STATISTISCHE TESTS ----------------------------------

## Hypothesenprüfung mit gemischtem linearen regressionsmodell

## TABELLE 22: STATISTISCHES MODELL MIT ALLEN COVARIABLEN
# Berechnung des generalisierten gemischten Regressionsmodells mit der bereinigten Stichprobe (data_4)
# Für Berechnung des generalisierten gemischten Regressionsmodells mit nicht bereinigter Stichprobe data_3 einsetzen
library(lme4)
Modell_gemischt_alle_cv <- glmer(Bewertung ~ Durchgefuehrtes_Experiment + Wortschatz_FrakisK +silbenstruktur+Phonemart+ID_Altersgruppe+(1|ID_Proband), family="binomial", data = data_4)
ergebnis_tabelle_alle_cv <- data.frame(Estimate_Exp=round(exp(coef(summary(Modell_gemischt_alle_cv)))[,1],digits=2),Estimate=round(coef(summary(Modell_gemischt_alle_cv))[,1],digits=2),Standardfehler=round(coef(summary(Modell_gemischt_alle_cv))[,2],digits=2),pWert=round(coef(summary(Modell_gemischt_alle_cv))[,4],digits=4))

summary(Modell_gemischt_alle_cv)
ergebnis_tabelle_alle_cv

# Kapitelabschnitt 7.1.2.2: Chi Square Test für Stimulusobjekte um auszuschließen, dass ein besonders auffälliger Einfluss eines/mehrerer Objektsets auf die Merkbarkeit besteht
# hier wird mit data_3, dem unbereinigten Datensatz, gearbeitet
kreuztabelle <- xtabs (~ data_3$Bewertung + data_3$ID_Objektset)
n <- sum(kreuztabelle)
erwartete_häufigkeiten <- outer (rowSums(kreuztabelle), colSums(kreuztabelle)) / n
erwartete_häufigkeiten

chisq.test(data_3$Bewertung, data_3$ID_Objektset)

# ------------------ ERGÄNZUNGSMATERIAL FÜR ANHANG ----------------------------------

## Beispiel-Mosaikplot aus Sample für exemplarische Beschreibung eines Mosaikplots
#install.packages("dplyr")
library(dplyr)
mosaic_sample <- sample_n(data_4,100)
nrow(mosaic_sample)

data_mosaik <- data.frame(table(mosaic_sample$Durchgefuehrtes_Experiment, mosaic_sample$Bewertung))
data_mosaik

ggplot(data_mosaik)+
  geom_mosaic(aes(
    x=product(Var2,Var1),
    fill=Var2,
    weight=Freq
  ))+
  labs(x="Experiment", y="Bewertung der Einzeltests",
       title = "Exemplarischer Mosaikplot: Merkbarkeit in Experiment 1 & 2",
       subtitle = "Sample von 100 Einzeltests aus der bereinigten Teilstichprobe") +
  theme_bw()+
  scale_fill_grey(start = .2, end = .8,
                  name="Bewertung")+
  geom_mosaic_text(aes(x = product(Var2,Var1), fill = Var2, label=frequency(Freq)))+
  mytheme
